import os
from setuptools import setup, find_packages

ROOT_DIRECTORY = os.path.dirname(__file__)

readme_path = os.path.join(ROOT_DIRECTORY, "README.md")
with open(readme_path) as readme:
    long_description = readme.read()

requirements_path = os.path.join(ROOT_DIRECTORY, "requirements.txt")
with open(requirements_path) as requirements:
    install_requires = requirements.readlines()

setup(
    name="trendio_ai_features",
    packages=find_packages(),
    version="0.0.2",
    description="Trendio get features for AI model.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="Trendio Team",
    author_email="arsen.ext@trendiolive.com",
    keywords=["trendio", "features"],
    install_requires=install_requires,
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.7",
)
