import logging
import boto3

from ..utils import NLP, OD

logging.basicConfig(level=20, format="%(asctime)s - %(levelname)s - %(message)s")
logger = logging.getLogger(__name__)

s3 = boto3.client("s3")


class BaseFeatureGenerator:
    def __init__(self, transcription_json: dict, od_json: dict = None, get_od: bool = True):
        self.transcription_json = transcription_json
        self.object_detection_json = od_json
        self.nlp = NLP(self.transcription_json)
        self.od = OD(self.object_detection_json) if get_od and od_json is not None else None

    def get_nlp_data(self, *args, **kwargs):
        raise NotImplementedError("Subclasses must implement get_nlp_data method")

    def get_od_data(self, *args, **kwargs):
        if self.od is None:
            raise NotImplementedError("OD data requested but OD instance is not initialized")

    def get_features_for_single_clip(self, *args, **kwargs):
        raise NotImplementedError("Subclasses must implement get_features_for_single_clip method")

    def get_features_for_video_file(self, *args, **kwargs):
        raise NotImplementedError("Subclasses must implement get_features_for_video_file method")
